
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   GENCONS.H - General Constant Definitions
// 
//
//   DESCRIPTION
//
//   Definitions of various useful conversion and configuration constants.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\GENCONS.H_V  $
//   
//      Rev 1.15   06 Nov 1998 17:47:00   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.3   Jul 09 1997 10:24:50   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:04:36   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:10:58   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:54:22   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#ifndef GENCONS_H
#define GENCONS_H


// GPS SV Constellation parameters
//
#define GI_MAX_SVS                     (32)
#define GI_MAX_VIS_SVS                 (12)
#define GI_SV_ID_NULL                  (0)
#define GI_SUBFRAME_ID_NULL            (0)


// Processor parameters
//
#define GI_BITS_PER_AAMP_WORD           (16)


// Access functions return/status values
//
#define GI_NEW_DATA                      (0)    // New data copied to struct
#define GI_OLD_DATA                      (1)    // No data copied
#define GI_CHG_DATA                      (-1)   // Data changed while copying
#define GI_LOCK_DATA                     (0x8000u) // No data copied
#define GI_DATA_OK                       (0)       // Data is valid, copied
#define GI_DATA_INVALID                  (2)       // No data copied
#define GI_ANY_DATA                      (0)       // Any new or old data
#define GI_INITIAL_SEQ_NO                (0)       // Seq number Initial values

// Time Constants
//
#define GI_FRAME_OF_SECONDS              (30)
#define GI_HOUR_OF_SECONDS               (3600)
#define GI_DAY_OF_SECONDS                (86400L)
#define GI_HALF_WEEK_OF_SECONDS          (302400L)
#define GI_WEEK_OF_SECONDS               (604800L)
#define GI_TWO_YEARS_IN_WEEKS            (104)

// HW Constants
//
#define GI_NUM_HW_CHAN                   (12)

// Numeric Constants
//
#define GF_PI                            (3.1415926535898)
#define GF_RPI                           (1.0/PI)
#define GF_HALF_PI                       (0.50*PI)
#define GF_TWO_PI                        (2.0*PI)
#define GI_BILLION                       (1000000000L)
#define GF_L1                            (1575.42E6)    // L1 Frequency in Hz
#define GF_SPEED_OF_LIGHT                (299792458.0)  //  Speed of Light m/s
#define GF_INCLINATION                   (0.942477796077)   // radians - blk 2 inclin = 54 deg 
#define GF_MU_SQRT                       (1.996498184e7)    // Sqrt of Mu - earth grav const
#define GF_EARTH_ROTATE                  (7.2921151467e-5)  // Earth rotation (r/s)

#endif
